<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

use App\Invoice;
use App\InvoiceItem;
use App\InvoiceItemTax;
use App\InvoiceTemplate;
use App\Company;
use App\Stock;
use App\Project;
use App\CompanySetting;
use App\Contact;
use App\Tax;
use DB;

class InvoiceCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'invoice:cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    public function get_company_option_cron($name, $optional='', $company_id) 
	{
		$setting = DB::table('company_settings')
					->where('name', $name)
					->where('company_id', $company_id)
					->get();
					
	    if ( ! $setting->isEmpty() ) {
		   return $setting[0]->value;
		}
		return $optional;

	}

    public function update_package_limit_cron($feature, $company_id) {
        $company = Company::find($company_id);
            if( $company->$feature != 'Yes' && $company->$feature != 'Unlimited'){
                $current_limit = (int) $company->$feature;
                $company->$feature = $current_limit - 1;
                $company->save();
            }
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        @ini_set('max_execution_time', 0);
		@set_time_limit(0);

        DB::beginTransaction();

		$existing_invoices = Invoice::where('recurring_interval', '>', 0)->orderBy('id', 'ASC')->get();
		foreach($existing_invoices as $existing_invoice) {
            $company_inv_limit = Company::find($existing_invoice->company_id);
            if($company_inv_limit->invoice_limit < 1) {
                continue;
            }

            // Next Invoice Date and Due Date Generation
            if(($existing_invoice->last_recurred_id > 0) && (Invoice::where('id', $existing_invoice->last_recurred_id)->get()->count() > 0)) {
                $last_recurred_inv = Invoice::find($existing_invoice->last_recurred_id);
                $db_inv_date = \Carbon\Carbon::createFromFormat('Y-m-d', $last_recurred_inv->invoice_date); 
                $db_due_date = \Carbon\Carbon::createFromFormat('Y-m-d', $last_recurred_inv->due_date);
            } else {
                $db_inv_date = \Carbon\Carbon::createFromFormat('Y-m-d', $existing_invoice->invoice_date); 
                $db_due_date = \Carbon\Carbon::createFromFormat('Y-m-d', $existing_invoice->due_date);
            }
            $recurring_interval = $existing_invoice->recurring_interval;
            $current_date = \Carbon\Carbon::createFromFormat('Y-m-d', date('Y-m-d'));  

            $diff_in_days = $current_date->diffInDays($db_inv_date);
            if($diff_in_days < $recurring_interval) {
                continue;
            }
            if($current_date->gt($db_inv_date)) {
                $recur_remainder = $diff_in_days % $recurring_interval;
                $recur_quotient = ($diff_in_days - $recur_remainder) / $recurring_interval;
                if($recur_quotient > 0) {
                    $next_inv_date = $db_inv_date->addDay($recurring_interval)->format('Y-m-d');
                    $next_due_date = $db_due_date->addDay($recurring_interval)->format('Y-m-d');
                }
            }

            // Creating Recurring Invoice
			$new_inv_no = $this->get_company_option_cron('invoice_prefix','',$existing_invoice->company_id).$this->get_company_option_cron('invoice_starting',1001,$existing_invoice->company_id);
			$invoice = new Invoice();
			$invoice->invoice_number = $new_inv_no;
			$invoice->invoice_date = $next_inv_date;
			$invoice->due_date = $next_due_date;
			$invoice->grand_total = $existing_invoice->grand_total;
			$invoice->tax_total = $existing_invoice->tax_total;
			$invoice->paid = 0;
			$invoice->status = 'Unpaid';
			$invoice->template = $existing_invoice->template;
			$invoice->recurring_interval = 0;
			$invoice->note = $existing_invoice->note;
            $invoice->related_to = $existing_invoice->related_to;
            $invoice->related_id = $existing_invoice->related_id;
            $invoice->client_id = $existing_invoice->client_id;
            $invoice->converted_total = $existing_invoice->converted_total;
            $invoice->company_id = $existing_invoice->company_id;
            $invoice->save();
            Invoice::where('id', $existing_invoice->id)->update(['last_recurred_id'=>$invoice->id]);

            // Save Invoice Items
            $existing_inv_items = InvoiceItem::where('invoice_id', $existing_invoice->id)->orderBy('id', 'ASC')->get();
            foreach($existing_inv_items as $existing_inv_item) {
                $invoiceItem = new InvoiceItem();
                $invoiceItem->invoice_id = $invoice->id;
                $invoiceItem->item_id = $existing_inv_item->item_id;
                $invoiceItem->description = $existing_inv_item->description;
                $invoiceItem->quantity = $existing_inv_item->quantity;
                $invoiceItem->unit_cost = $existing_inv_item->unit_cost;
                $invoiceItem->discount = $existing_inv_item->discount;
                $invoiceItem->tax_amount = $existing_inv_item->tax_amount;
                $invoiceItem->sub_total = $existing_inv_item->sub_total;
                $invoiceItem->company_id = $existing_inv_item->company_id;
                $invoiceItem->save();

                //Store Invoice Taxes
                $existing_inv_taxes = InvoiceItemTax::where('invoice_id', $existing_invoice->id)->where('invoice_item_id', $existing_inv_item->id)->get();
                foreach($existing_inv_taxes as $existing_inv_tax) {
                    $invoiceItemTax = new InvoiceItemTax();
                    $invoiceItemTax->invoice_id = $existing_inv_tax->invoice_id;
                    $invoiceItemTax->invoice_item_id = $existing_inv_tax->invoice_item_id;
                    $invoiceItemTax->tax_id = $existing_inv_tax->tax_id;
                    $invoiceItemTax->name = $existing_inv_tax->name;
                    $invoiceItemTax->amount = $existing_inv_tax->amount;
                    $invoiceItemTax->company_id = $existing_inv_tax->company_id;
                    $invoiceItemTax->save();
                }

                //Update Stock if Order Status is received
                // if( has_feature('inventory_module') ){
                    // if($request->input('order_status') != 'Canceled'){
                        $stock = Stock::where("product_id", $invoiceItem->item_id)->where("company_id",$invoiceItem->company_id)->first();
                        if(!empty($stock)){
                            $stock->quantity =  $stock->quantity - $invoiceItem->quantity;
                            $stock->company_id =  $invoiceItem->company_id;
                            $stock->save();
                        }
                    // }
                // }
            }

            // Increment Invoice Number
            $company_id = $existing_invoice->company_id;
            $data = array();
            $data['value'] = $this->get_company_option_cron('invoice_starting',1001,$company_id) + 1;
            $data['company_id'] = $company_id;
            $data['updated_at'] = date('Y-m-d H:i:s');

            if(\App\CompanySetting::where('name', "invoice_starting")->where("company_id",$company_id)->exists()){				
                \App\CompanySetting::where('name','invoice_starting')
                              ->where("company_id",$company_id)
                              ->update($data);			
             }else{
                $data['name'] = 'invoice_starting'; 
                $data['created_at'] = date('Y-m-d H:i:s');
                \App\CompanySetting::insert($data); 
             }

             //Update Package limit
             $this->update_package_limit_cron('invoice_limit',$company_id);

             if($invoice->client->user->id != null){
                Notification::send($invoice->client->user, new InvoiceCreated($invoice));
             }

             DB::commit();

			// \Log::info($new_inv_no);
		}
 

		// echo 'some text';

        // \Log::info("Cron is working fine!");
    }
}
